/* Affichage de ton nom:
Version française de Chasing blink
*/
/*Chasing Blink
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 3 74HC595 shift register attached to pins 8, 11, and 12 of the Arduino,
 as detailed below.
 * 24 LEDs attached to each of the outputs of the shift register
 * 24 220 Ohm resistors
 
 Adapted from
 Shift Register Examples
 for 74HC595 shift register
 
 by Tom Igoe and Carlyn Maw  
 
 
Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */


// La broche reliée à la broche LATCH (verrou) du 74HC595
int brocheVerrou = 8;
// La broche reliée à la broche CLOCK (horloge) du 74HC595
int brocheHorloge = 12;
// La broche reliée à la broche LATCH (verrou) du 74HC595
int brocheDonnees = 11;
// Le nombre de registres à décalage utilisés
int nombreRegistres = 3;
// La première combinaison à afficher
int combinaison1 = 85;
// La deuxième combinaison à afficher
int combinaison2 = 170;
void setup() {
  // Déclaration en mode sortie des broches utilisées dans
  // la boucle principale
  pinMode(brocheVerrou, OUTPUT);
  pinMode(brocheDonnees, OUTPUT);
  pinMode(brocheHorloge, OUTPUT);
  // Démarrage avec toutes les LED éteintes
  commandeLED(0);
}

void loop() {
  // Activer les LED selon la combinaison 01010101
  commandeLED(combinaison1);
  // Attendre 1 seconde
  delay(1000);
  // Activer les LED selon la combinaison 10101010
  commandeLED(combinaison2);
  // Attendre 1 seconde
  delay(1000);
}

// Envoie les combinaisons au registre à décalage
// pour allumer ou éteindre les LED
void commandeLED(int combinaisonLED) {
  // Force le verouillage des sorties afin que les
  // LED restent éteintes pendant le décalage des bits :
  digitalWrite(brocheVerrou, LOW);
  int i;
  for(i=0; i<nombreRegistres; i++) {
    // Envoie la combinaison à chaque registre à décalage
    shiftOut(brocheDonnees, brocheHorloge, LSBFIRST,
    combinaisonLED);
  }
  // Déverrouille les sorties afin d’activer les LED :
  digitalWrite(brocheVerrou, HIGH);
  delay(300);
}
